@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <div class="play-body">
        <div class="play-video">
            <div class="primary">
                <div class="primary__videoPlayer video-item__thumb mainVideo ">
                    @if ($purchasedTrue && $video->audience)
                        <div class="hidden-content ">
                            <div class="form-group">
                                <h4>{{ __(gs('vc_warning')->title) }}</h4>
                                <p class="mb-3">{{ __(gs('vc_warning')->description) }} </p>
                                <button class="btn btn--base SeeBtn">@lang('See Video')</button>
                            </div>
                        </div>
                    @endif
                    <video class="video-player " data-poster="{{ getImage(getFilePath('thumbnail') . '/' . $video->thumb_image) }}" controls @if ($video->stock_video) data-video_id="{{ $video->id }}" @endif>
                        @if ($purchasedTrue)
                            @foreach ($video->videoFiles as $file)
                                <source src="{{ getImage(getFilePath('video') . '/' . $file->file_name) }}" type="video/mp4" size="{{ $file->quality }}" />
                            @endforeach
                            @foreach ($video->subtitles as $subtitle)
                                <track src="{{ getImage(getFilePath('subtitle') . '/' . $subtitle->file) }}" srclang="{{ $subtitle->language_code }}" kind="captions" label="{{ $subtitle->caption }}" default />
                            @endforeach
                        @endif
                    </video>


                    @if (!$purchasedTrue)
                        <div class="premium-stock">
                            <div class="premium-stock-lock">
                                <svg class="lucide lucide-lock" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <rect width="18" height="11" x="3" y="11" rx="2" ry="2" />
                                    <path d="M7 11V7a5 5 0 0 1 10 0v4" />
                                </svg>
                            </div>

                            <div class="premium-stock-inner">
                                <div class="left">
                                    <div class="premium-stock-price">
                                        {{ gs('cur_sym') }}{{ showAmount($video->price, currencyFormat: false) }}
                                    </div>
                                    <div class="premium-stock-icon">
                                        <svg class="_24ydrq0 _1286nb17o _1286nb12r6" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="16" height="16">
                                            <path
                                                  d="M486.2 50.2c-9.6-3.8-20.5-1.3-27.5 6.2l-98.2 125.5-83-161.1C273 13.2 264.9 8.5 256 8.5s-17.1 4.7-21.5 12.3l-83 161.1L53.3 56.5c-7-7.5-17.9-10-27.5-6.2C16.3 54 10 63.2 10 73.5v333c0 35.8 29.2 65 65 65h362c35.8 0 65-29.2 65-65v-333c0-10.3-6.3-19.5-15.8-23.3">
                                            </path>
                                        </svg>
                                        @lang('Premium')
                                    </div>
                                </div>
                                <div class="premium-stock-text">
                                    @lang('Purchase Now')
                                </div>
                            </div>
                        </div>
                    @endif
                </div>

                <div class="ad-wrapper position-relative adVideo d-none ">

                </div>

                <h4 class="primary__vtitle">{{ __($video->title) }}</h4>

                <div class="primary__videometa">
                    <div class="items">
                        <span class="view"> <span class="icon"><i class="fa-regular fa-eye"></i></span>
                            {{ formatNumber($video->views) }} @lang('views')</span>
                        <span class="date"> <span class="icon"><i class="fa-regular fa-clock"></i></span>
                            {{ $video->created_at->diffForHumans() }}</span>
                    </div>
                    @if (auth()->check())
                        <div class="meta-buttons">
                            <div class="meta-react-wrapper">
                                <div class="meta-react-inner">
                                    <button class="meta-buttons__button reactionBtn" data-reaction="1">
                                        <span class="icon">
                                            @if ($video->isLikedByAuthUser)
                                                <i class="vti-like-fill reactionIcon"></i>
                                            @else
                                                <i class="vti-like reactionIcon"></i>
                                            @endif
                                        </span>
                                        <span
                                              class="text likeCount">{{ formatNumber($video->reactionLikeCount) }}</span>
                                    </button>
                                    <button class="meta-buttons__button reactionBtn" data-reaction="0">
                                        <span class="icon">
                                            @if ($video->isUnlikedByAuthUser)
                                                <i class="vti-dislike-fill reactionIcon"></i>
                                            @else
                                                <i class="vti-dislike reactionIcon"></i>
                                            @endif
                                        </span>
                                    </button>
                                </div>

                            </div>

                            <button class="meta-buttons__button shareBtn">
                                <span class="icon">
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                        <path fill-rule="evenodd" fill="currentColor" clip-rule="evenodd" d="M4 11c.55228 0 1 .4477 1 1v8a.99997.99997 0 0 0 1 1h12c.2652 0 .5196-.1054.7071-.2929A1.0001 1.0001 0 0 0 19 20v-8c0-.5523.4477-1 1-1s1 .4477 1 1v8a2.9999 2.9999 0 0 1-.8787 2.1213A2.9999 2.9999 0 0 1 18 23H6a3.00006 3.00006 0 0 1-3-3v-8c0-.5523.44772-1 1-1Zm8-10c.2652 0 .5196.10536.7071.29289l4 4c.3905.39053.3905 1.02369 0 1.41422-.3905.39052-1.0237.39052-1.4142 0L12 3.41421l-3.29289 3.2929c-.39053.39052-1.02369.39052-1.41422 0-.39052-.39053-.39052-1.02369 0-1.41422l4.00001-4A.99997.99997 0 0 1 12 1Z">
                                        </path>
                                        <path fill-rule="evenodd" d="M12 1c.5523 0 1 .44772 1 1v13c0 .5523-.4477 1-1 1s-1-.4477-1-1V2c0-.55228.4477-1 1-1Z" clip-rule="evenodd"></path>
                                    </svg>
                                </span>
                                <span class="text">@lang('Share')</span>
                            </button>
                            @if ($video->stock_video == Status::NO)
                                <button class="meta-buttons__button embed">
                                    <span class="icon"><svg width="18" height="18" viewBox="0 0 16 16">
                                            <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" d="m10.67 12 4-4-4-4M5.33 4l-4 4 4 4"></path>
                                        </svg></span>
                                    <span class="text">@lang('Embed')</span>
                                </button>
                            @endif
                            <button class="meta-buttons__button watchLater">
                                <span class="icon">
                                    @if ($watchLater)
                                        <svg class="lucide lucide-square-check-big" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M21 10.5V19a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h12.5" />
                                            <path d="m9 11 3 3L22 4" />
                                        </svg>
                                    @else
                                        <svg class="lucide lucide-clock" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <circle cx="12" cy="12" r="10" />
                                            <polyline points="12 6 12 12 16 14" />
                                        </svg>
                                    @endif
                                </span>
                                <span class="text"> @lang('Watch Later')</span>
                            </button>

                            <button class="meta-buttons__button saveBtn">
                                <span class="icon">

                                    <svg class="lucide lucide-save" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M15.2 3a2 2 0 0 1 1.4.6l3.8 3.8a2 2 0 0 1 .6 1.4V19a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2z" />
                                        <path d="M17 21v-7a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v7" />
                                        <path d="M7 3v4a1 1 0 0 0 1 1h7" />
                                    </svg>
                                </span>
                                <span class="text"> @lang('Save to Playlist')</span>
                            </button>


                        </div>
                    @endif
                </div>
                <div class="primary__channel">
                    <div class="author">
                        <a class="author__thumb" href="{{ route('preview.channel', $video->user->slug) }}">
                            <img src="{{ getImage(getFilePath('userProfile') . '/' . $video->user->image) }}" alt="image">
                        </a>

                        <div class="author__content">
                            <span class="author__subscriber"><span
                                      class="subscriberCount">{{ formatNumber($video->user->subscribers()->count()) }}</span>
                                @lang('Subscriber')</span>
                        </div>
                    </div>


                    @if (@auth()->id() != $video->user_id)
                        @php
                            $subscribed = $video->user->subscribers()->where('following_id', auth()->id())->exists();
                        @endphp

                        <div class="subscriber-btn">
                            <button class="btn cta @if (!$subscribed) btn--white subcriberBtn @else  btn--white outline unSubcriberBtn @endif">
                                @if (!$subscribed)
                                    @lang('Subscribe')
                                    <span class="shape">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </span>
                                @else
                                    @lang('Unsubscribe')
                                @endif
                            </button>
                        </div>
                        </section>
                    @endif
                </div>
                <div class="primary__desc">
                    <div class="primary__desc-text">
                        @php
                            $descriptionLimit = 100;
                            echo $video->description;
                        @endphp
                    </div>
                    @if (strlen($video->description) > $descriptionLimit)
                        <button class="primary__desc-button">@lang('Show More')</button>
                    @endif
                </div>

                <div class="primary__comment d-none d-xl-block">
                    <div class="top">
                        <h5 class="comment-number"><span class="commentCount">{{ count($video->allComments) }}</span>
                            @lang('Comments')</h5>

                    </div>
                    @if (auth()->check())
                        <div class="comment-form-wrapper">
                            <span class="comment-author">
                                <img class="fir-image" src="{{ getImage(getFilePath('userProfile') . '/' . auth()->user()->image) }}" alt="">
                            </span>

                            <form class="comment-form" method="post">
                                @csrf
                                <div class="form-group position-relative">

                                    <textarea class="form--control commentBox" name="comment" placeholder="Add a comment"></textarea>

                                    <button class="comment-btn" type="submit">
                                        <svg class="lucide lucide-send-horizontal" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path
                                                  d="M3.714 3.048a.498.498 0 0 0-.683.627l2.843 7.627a2 2 0 0 1 0 1.396l-2.842 7.627a.498.498 0 0 0 .682.627l18-8.5a.5.5 0 0 0 0-.904z" />
                                            <path d="M6 12h16" />
                                        </svg>
                                    </button>
                                </div>
                            </form>
                        </div>
                    @endif
                </div>
                <div class="primary__comment-list comment-box__content d-none d-xl-block">
                    <div class="comment-bow-wrapper">
                        @include($activeTemplate . 'partials.video.comments')
                    </div>
                </div>
                <div class="text-center spinner mt-4 d-none w-100" id="loading-spinner">
                    <i class="las la-spinner"></i>
                </div>
            </div>
            <div class="secondary">
                <div class="tag_sliders owl-carousel">
                    <a class="tag-item" href="{{ route('category.video', 'all') }}">@lang('All')</a>
                    @foreach ($categories as $category)
                        <a class="tag-item" href="{{ route('category.video', $category->slug) }}">{{ __($category->name) }}</a>
                    @endforeach
                </div>
                <div class="secondary__playlist">
                    @include($activeTemplate . 'partials.video.related_video')
                </div>
            </div>
            <div class="primary d-xl-none d-block mt-5 mb-4 comment-box__content">
                <div class="top mb-3">
                    <h5 class="comment-number"><span class="commentCount">{{ count($video->allComments) }}</span>
                        @lang('Comments')</h5>
                </div>
                @if (auth()->check())
                    <div class="primary__comment">
                        <div class="comment-form-wrapper">
                            <span class="comment-author">
                                <img class="fir-image" src="{{ getImage(getFilePath('userProfile') . '/' . auth()->user()->image) }}" alt="">
                            </span>

                            <form class="comment-form" method="post">
                                @csrf
                                <div class="form-group position-relative">
                                    <textarea class="form--control" name="comment" placeholder="Add a comment"></textarea>
                                    <button class="comment-btn" type="submit">
                                        <svg class="lucide lucide-send-horizontal" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path
                                                  d="M3.714 3.048a.498.498 0 0 0-.683.627l2.843 7.627a2 2 0 0 1 0 1.396l-2.842 7.627a.498.498 0 0 0 .682.627l18-8.5a.5.5 0 0 0 0-.904z" />
                                            <path d="M6 12h16" />
                                        </svg>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                @endif
                @include($activeTemplate . 'partials.video.comments')
            </div>
        </div>
    </div>

    {{-- unSubcriberModal --}}
    <div class="modal scale-style fade custom--modal" id="unSubcriberModal" aria-labelledby="unSubcriberModalLabel" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Confirm Alert!')</h5>
                    <button class="close modal-close-btn" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <p>@lang('Are you sure you want to unsubscribe this channel?')</p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn--sm btn--white outline" data-bs-dismiss="modal" type="button">@lang('No')</button>
                    <button class="btn btn--sm btn--white confirmUnsubscribe" type="button">@lang('Yes')</button>
                </div>
            </div>
        </div>
    </div>

    {{-- shareModal --}}
    <div class="custom--modal fade scale-style modal" id="shareModal" aria-labelledby="exampleModalLabel" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Share On')</h5>
                    <button class="btn-close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="share-items">
                        <a class="share-item whatsapp" href="https://api.whatsapp.com/send?text={{ route('video.play', [$video->id, $video->slug]) }}" target="_blank">
                            <i class="lab la-whatsapp"></i>
                        </a>
                        <a class="share-item facebook" href="https://www.facebook.com/sharer/sharer.php?u={{ route('video.play', [$video->id, $video->slug]) }}" target="_blank">
                            <i class="lab la-facebook-f"></i>
                        </a>

                        <a class="share-item twitter" href="https://twitter.com/intent/tweet?url={{ route('video.play', [$video->id, $video->slug]) }}&text={{ $video->title }}" target="_blank">
                            <i class="fa-brands fa-x-twitter"></i>
                        </a>
                        <a class="share-item envelope" href="mailto:?subject={{ $video->title }}&body={{ route('video.play', [$video->id, $video->slug]) }}">
                            <i class="las la-envelope"></i>
                        </a>

                    </div>

                    <div class="share-embed">
                        <input class="form--control copyText" type="text" value="{{ route('video.play', [$video->id, $video->slug]) }}">
                        <button class="share-embed-btn copyBtn">@lang('Copy')</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- embed --}}
    <div class="custom--modal fade scale-style modal" id="embedModal" aria-labelledby="exampleModalLabel" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Embeded Link')</h5>
                    <button class="btn-close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="share-embed">
                        <textarea class="form--control copyText"><iframe src="{{ route('embed', [$video->id, $video->slug]) }}" width="560" height="315" frameborder="0" allowfullscreen></iframe></textarea>
                        <button class="share-embed-btn copyBtn">@lang('Copy')</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- login modal --}}
    @include($activeTemplate . 'partials.login_alert_modal')

    @if (!$purchasedTrue)
        <div class="modal custom--modal payment-modal scale-style fade" id="confirmationModal" aria-labelledby="playlistModalLabel" aria-hidden="true" tabindex="-1">
            <div class="modal-dialog modal-lg modal-dialog-centered">
                <div class="modal-content ">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('Please purchase this video to access our premium content')</h5>

                        <button class="close modal-close-btn" data-bs-dismiss="modal" type="button" aria-label="Close">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <form class="deposit-form" action="{{ route('user.deposit.insert') }}" method="post">
                        @csrf
                        <input name="currency" type="hidden">
                        <input name="video_id" type="hidden" value="{{ @$video->id }}">
                        <div class="gateway-card">
                            <div class="row justify-content-center gy-sm-4 gy-3">

                                <div class="col-lg-6">
                                    <div class="payment-system-list is-scrollable gateway-option-list">
                                        @foreach ($gatewayCurrency as $data)
                                            <label
                                                   class="payment-item @if ($loop->index > 4) d-none @endif gateway-option" for="{{ titleToKey($data->name) }}">
                                                <div class="payment-item-left">
                                                    <div class="payment-item__thumb">
                                                        <img class="payment-item__thumb-img" src="{{ getImage(getFilePath('gateway') . '/' . $data->method->image) }}" alt="@lang('payment-thumb')">
                                                    </div>
                                                    <span class="payment-item__name">{{ __($data->name) }}</span>
                                                </div>

                                                <span class="check-type-icon">
                                                    <svg class="check-circle" width="13" height="10" viewBox="0 0 13 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path class="check" d="M1 5L4.5 8.5L12.5 0.5" stroke="currentColor" stroke-linecap="round"></path>
                                                    </svg>
                                                </span>

                                                <input class="payment-item__radio gateway-input" id="{{ titleToKey($data->name) }}" name="gateway" data-gateway='@json($data)' data-min-amount="{{ showAmount($data->min_amount) }}" data-max-amount="{{ showAmount($data->max_amount) }}" type="radio" value="{{ $data->method_code }}" hidden @if (old('gateway')) @checked(old('gateway') == $data->method_code) @else @checked($loop->first) @endif>
                                            </label>
                                        @endforeach
                                        @if ($gatewayCurrency->count() > 4)
                                            <button class="payment-item__btn more-gateway-option" type="button">
                                                <p class="payment-item__btn-text">@lang('Show All Payment Options')</p>
                                                <span class="payment-item__btn__icon"><i
                                                       class="fas fa-chevron-down"></i></i></span>
                                            </button>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="payment-system-list border-style">
                                        <div class="deposit-info">
                                            <div class="deposit-info__title">
                                                <p class="text mb-0">@lang('Amount')</p>
                                            </div>
                                            <div class="deposit-info__input">
                                                <div class="deposit-info__input-group input-group">
                                                    <span
                                                          class="deposit-info__input-group-text">{{ gs('cur_sym') }}</span>
                                                    <input class="form-control form--control amount" name="amount" type="text" value="{{ getAmount($video->price) }}" placeholder="@lang('00.00')" readonly autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="deposit-info">
                                            <div class="deposit-info__title">
                                                <p class="text has-icon"> @lang('Limit')
                                                    <span></span>
                                                </p>
                                            </div>
                                            <div class="deposit-info__input">
                                                <p class="text"><span class="gateway-limit">@lang('0.00')</span>
                                                </p>
                                            </div>
                                        </div>
                                        <div class="deposit-info">
                                            <div class="deposit-info__title">
                                                <p class="text has-icon">@lang('Processing Charge')
                                                    <span class="proccessing-fee-info" data-bs-toggle="tooltip" title="@lang('Processing charge for payment gateways')"><i class="las la-info-circle"></i>
                                                    </span>
                                                </p>
                                            </div>
                                            <div class="deposit-info__input">
                                                <p class="text"><span class="processing-fee">@lang('0.00')</span>
                                                    {{ __(gs('cur_text')) }}
                                                </p>
                                            </div>
                                        </div>

                                        <div class="deposit-info total-amount pt-3">
                                            <div class="deposit-info__title">
                                                <p class="text">@lang('Total')</p>
                                            </div>
                                            <div class="deposit-info__input">
                                                <p class="text"><span class="final-amount">@lang('0.00')</span>
                                                    {{ __(gs('cur_text')) }}</p>
                                            </div>
                                        </div>

                                        <div class="deposit-info gateway-conversion d-none total-amount pt-2">
                                            <div class="deposit-info__title">
                                                <p class="text">@lang('Conversion')
                                                </p>
                                            </div>
                                            <div class="deposit-info__input">
                                                <p class="text"></p>
                                            </div>
                                        </div>
                                        <div class="deposit-info conversion-currency d-none total-amount pt-2">
                                            <div class="deposit-info__title">
                                                <p class="text">
                                                    @lang('In') <span class="gateway-currency"></span>
                                                </p>
                                            </div>
                                            <div class="deposit-info__input">
                                                <p class="text">
                                                    <span class="in-currency"></span>
                                                </p>

                                            </div>
                                        </div>
                                        <div class="d-none crypto-message mb-3">
                                            <div class="note-text">
                                                <span class="icon"><i class="fas fa-info-circle"></i></span>
                                                <p>
                                                    @lang('Conversion with') <span class="gateway-currency"></span>
                                                    @lang('and final value will Show on next step')
                                                </p>
                                            </div>
                                        </div>
                                        <button class="btn btn--base w-100" type="submit" disabled>
                                            @lang('Payment Confirm')
                                        </button>
                                        <div class="info-text pt-3">
                                            <p class="text note-text">
                                                <span class="icon"><i class="fas fa-info-circle"></i></span>
                                                @lang('Ensuring your funds grow safely through our secure payment process with world-class payment options.')
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif


    {{-- add playlist modal --}}
    <div class="modal custom--modal scale-style fade" id="addVideoModal" aria-labelledby="addVideoModal" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button class="close modal-close-btn" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form class="add-video-form" method="post">
                    @csrf
                    <input name="video_id" type="number" value="{{ @$video->id }}" hidden>
                    <div class="modal-body playlist-list">
                        @foreach ($playlists as $playlist)
                            <label class="check-type mb-2 w-100" for="flexCheck{{ $playlist->id }}">
                                <input class="check-type-input" id="flexCheck{{ $playlist->id }}" name="playlist_id[]" type="checkbox" value="{{ $playlist->id }}" @if (in_array($playlist->id, $video->playlists->pluck('id')->toArray())) checked @endif>
                                <span class="check-type-icon">
                                    <svg class="check-circle" width="13" height="10" viewBox="0 0 13 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path class="check" d="M1 5L4.5 8.5L12.5 0.5" stroke="currentColor" stroke-linecap="round">
                                        </path>
                                    </svg>
                                </span>
                                <span class="check-type-label" for="flexCheck{{ $playlist->id }}">
                                    <p>{{ __($playlist->title) }}</p>
                                </span>
                            </label>
                        @endforeach
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--base submitBtn w-100 btn--sm" type="button">@lang('Add')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>




@endsection

@push('style')
    <style>
        .divtext {
            border: ridge 2px;
            padding: 5px;
            width: 20em;
            min-height: 5em;
            overflow: auto;
        }

        .playlist-list {
            height: 250px;
            overflow: auto;
        }

        .video-item__play {
            position: absolute;
            margin: 0 auto;
            left: 50%;
            top: 50%;
        }

        .spinner {
            text-align: center;
            margin-top: 20px;
        }

        .spinner i {
            font-size: 45px;
            color: #ff0000;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .modal-header {
            border-bottom: 1px solid #e9ecef;
        }

        .modal-title {
            font-weight: bold;
        }

        .share-icons {
            display: flex;
            justify-content: space-around;
            margin-bottom: 15px;
        }

        .share-icon {
            font-size: 35px;
            color: #555;
            transition: color 0.3s ease;
        }

        .share-icon:hover {
            color: #007bff;
        }

        .hidden-content {
            position: absolute;
            width: 100%;
            height: 100%;
            background: black;
            left: 0px;
            right: 0px;
            z-index: 1;
            opacity: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
        }

        .primary__desc-text {
            max-height: 100px;
            overflow: hidden;
            transition: max-height 0.5s ease;
        }

        .primary__desc-text.expanded {
            max-height: 1000px;
        }

        .primary__desc-button {
            cursor: pointer;
            color: #ffffff;
            background: none;
            border: none;
            padding: 0;
            font-size: 16px;
            text-transform: uppercase;
            margin-top: 10px;
        }

        .skip-btn {
            padding: 8px 20px;
            color: hsl(var(--white));
            border-radius: 5px;
            position: absolute;
            right: 30px;
            bottom: 10%;
        }

        .ad-info__button {
            position: absolute;
            bottom: 70px;
            left: 30px;
            width: 320px;
            background: #fff;
            padding: 20px;
            border-radius: 10px;
            gap: 15px;
            align-items: center
        }

        @media (max-width:767px) {
            .ad-info__button {
                width: 100%;
                position: unset;
                border-radius: 0;
            }

            .ad-click-content {
                width: 100% !important;
                position: unset !important;
            }

            .skip-btn {
                padding: 6px 8px;
                border-radius: 5px;
                position: absolute;
                right: 12px;
                font-size: 12px;
            }
        }

        .ad-info__thumb {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            overflow: hidden;
        }

        .ad-info__thumb img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .ad-info__content {
            width: calc(100% - 30px);
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            gap: 10px
        }

        .ad-info__content .btn {
            width: 80px;
        }

        .ad-info__content .content {
            width: calc(100% - 70px);
        }

        .ad-info__content .content__title {
            margin-bottom: 4px;
            color: #000;
        }

        .ad-info__content .content__mail {
            font-size: 10px;
        }

        .content__title .ad-btn {
            font-size: 13px;
        }

        .comment-item__commenter-thumb img {
            width: 30px;
            border-radius: 50%;
        }




        .cmn-button-item {
            text-align: center;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        .action-container__thumb img {
            width: 40px;
            height: 40px;
            border-radius: 50%;
        }


        .commnet-form {
            height: 100px;
            position: fixed;
            background: hsl(var(--black));
            bottom: 0;
            width: 100%;
            z-index: 999;
            border-top: 1px solid hsl(var(--white)/.3);
        }

        .commnet-form .form--control {
            background-color: transparent;
            border: 0;
            border-bottom: 1px solid hsl(var(--white)/.2);
            border-radius: 0;
        }

        .reply-form::after {
            content: "";
            display: block;
            width: 0;
            height: 1px;
            background: hsl(var(--white));
            position: absolute;
            bottom: -1px;
            left: 0;
            transition: all 0.1s linear;
        }

        .reply-form:focus-within::after {
            width: 100%;
        }


        .button-item {
            color: hsl(var(--white));
            width: 40px;
            height: 40px;
            display: flex;
            justify-content: center;
            align-items: center;
            border-radius: 50%;
            background-color: hsl(var(--black)/.25);
        }

        .reply-form__input-btn {
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }

        .reply-form {
            position: relative;
        }

        .reply-form__btn {
            color: hsl(var(--white));
            background: transparent;
            font-size: 1rem;
            position: absolute;
            top: 0;
            right: 0;
            height: 100%;
            width: 40px;
        }

        .comment-box__header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
            padding: 20px;
            padding-bottom: 0;
        }

        .comment-box__title {
            margin-bottom: 0;
        }

        .comment-box__close-icon {
            color: hsl(var(--white));
        }

        .comment-box {
            position: absolute;
            width: 380px;
            right: 0;
            top: 0;
            height: 100%;
            background-color: hsl(var(--black-d-200));
            visibility: hidden;
            opacity: 0;
            transform: translateX(0);
            transition: .3s linear;
            z-index: -1;
            overflow-y: hidden;
            border: 1px solid hsl(var(--white)/.1);
            border-radius: 6px;
        }

        @media (max-width:1499px) {
            .comment-box {
                width: 320px;
            }
        }



        .comment-box.show-comment {
            visibility: visible;
            opacity: 1;
            transform: translateX(100%);
        }

        .reply {
            cursor: pointer;
            font-size: 14px;
            color: hsl(var(--white));
        }

        .reply-wrapper {
            margin-top: 16px;
        }

        .show-reply {
            margin-top: 6px;
        }

        .reply-form .form--control {
            border: 0;
            border-bottom: 1px solid hsl(var(--white) / .1);
            border-radius: 0;
            padding: 0;
            font-size: 0.875rem;
            color: hsl(var(--heading-color));
            background-color: transparent;
            padding-right: 60px;
        }

        .comment-box-item__content {
            width: calc(100% - 40px);
        }

        .comment-box-item__name {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 5px;
            font-size: 13px;
            color: hsl(var(--white) / .9);
        }

        .comment-box-item__text {
            font-size: 14px;
            color: hsl(var(--white));
            font-weight: 500;
        }

        .comment-box-item__name .time {
            font-size: 12px;
            color: hsl(var(--body-color));
            display: block;
        }

        .reaction-btn {
            display: flex;
            align-items: center;
            gap: 24px;
            margin-top: 12px;
        }

        .comment-box-item {
            display: flex;
            gap: 15px;
            margin-bottom: 15px;
        }

        .comment-box-item:last-child {
            margin-bottom: 0;
        }

        .comment-box-item__thumb {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            overflow: hidden;
        }

        .comment-box__content {
            overflow-y: scroll;
            max-height: 510px;
            padding-left: 32px;
            padding-top: 16px;
        }

        @media (max-width: 767px) {
            .comment-box__content {
                padding-left: 16px;
            }
        }

        @media (max-width: 575px) {
            .comment-box__content {
                padding-left: 6px;
            }
        }

        @media (max-width: 1199px) {
            .comment-box__content {
                max-height: unset;
            }
        }

        .comment-box__content::-webkit-scrollbar {
            width: 5px;
        }

        .comment-box__content::-webkit-scrollbar-thumb {
            background: hsl(var(--white) / .2);
            border-radius: 10px;
        }

        .comment-box__content::-webkit-scrollbar-track {
            background: transparent;
        }

        .primary__comment {
            padding-left: 32px;
        }

        @media (max-width: 1199px) {
            .primary__comment {
                padding-left: 0;
            }
        }


        .comment-box-item__thumb img {
            width: 100%;
            height: 100%;
        }

        .video-item__thumb:hover .video-item__price {
            transform: translateY(0);
        }

        .ad-info {
            position: absolute;
            bottom: 30px;
            left: 20px;
            background: hsl(var(--white));
            box-shadow: 0 0 20px hsl(var(--black)/.2);
            padding: 20px;
            display: flex;
            align-items: center;
            gap: 15px;
            border-radius: 6px;
        }

        @media (max-width:575px) {
            .ad-info {
                position: relative;
                left: 0;
                bottom: 0;
                border-radius: 0;
                padding: 10px;
            }

            .skip-btn {
                bottom: 28%;
            }
        }

        .ad-info__content a {
            background: hsl(var(--base));
            padding: 5px 10px;
            border-radius: 30px;
            font-size: 12px;
            color: hsl(var(--white));
        }

        .ad-info__content p {
            color: hsl(var(--black));
            font-weight: 600;
        }

        .commentBox {
            display: block;
            overflow: hidden;
            resize: none;

        }

        textarea.form--control {
            height: unset;
        }
    </style>
@endpush

@push('style-lib')
    <link href="{{ asset('assets/global/css/plyr.css') }}" rel="stylesheet">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/global/js/plyr.js') }}"></script>
@endpush

@push('script')
    <script>
        (function($) {
            'use strict';



            $(document).on('click', 'button.cta', function() {
                $(this).addClass('active');
                setTimeout(() => {
                    $(this).removeClass('active');
                }, 300);
            });

            $(document).ready(function() {
                $('.primary__desc-button').on('click', function() {
                    var descText = $('.primary__desc-text');
                    if (descText.hasClass('expanded')) {
                        descText.removeClass('expanded').css('max-height', '100px');
                        $(this).text('@lang('Show More')');
                    } else {
                        var scrollHeight = descText.prop('scrollHeight');
                        descText.addClass('expanded').css('max-height', scrollHeight + 'px');
                        $(this).text('@lang('Show Less')');
                    }
                });
            });

            $(document).ready(function() {
                $(document).on('input', '.commentBox', function() {
                    $(this).css('height', 'auto');
                    $(this).css('height', this.scrollHeight + 'px');

                });
            });


            const auth = "{{ auth()->user() }}";
            $('.submitBtn').on('click', function(e) {
                e.preventDefault();
                const url = "{{ route('user.video.add.playlist') }}";
                const formData = $('.add-video-form').serialize();
                $.ajax({
                    type: "POST",
                    url: url,
                    data: formData,
                    dataType: "json",
                    success: function(response) {
                        $('#addVideoModal').modal('hide');


                        if (response.error) {
                            notify('error', response.error)
                        } else {
                            notify('success', response.success)
                        }
                    }

                });
            });

            $(document).ready(function() {
                // for vidoe player
                const stockVideo = "{{ $video->stock_video }}";
                const purchasedTrue = "{{ $purchasedTrue }}"
                const authVideo = "{{ $video->user_id == auth()->id() }}"

                var controls = [];
                if (stockVideo == 0 || purchasedTrue || authVideo) {
                    controls = [
                        'rewind',
                        'play',
                        'fast-forward',
                        'progress',
                        'current-time',
                        'duration',
                        'mute',
                        'settings',
                        'fullscreen',
                        'pip'
                    ];
                } else if (!auth) {
                    controls = [
                        'play-large',
                    ];
                    $(document).on('click', '.plyr__control--overlaid, .primary__videoPlayer ', function() {
                        singleplayer.pause();
                        $('#existModalCenter').modal('show');
                    });

                } else if (stockVideo == 1 && !purchasedTrue || authVideo) {
                    controls = [
                        'play-large',
                    ];

                    $(document).on('click', '.plyr__control--overlaid, .primary__videoPlayer ', function() {
                        singleplayer.pause();
                        const modal = $('#confirmationModal');
                        modal.modal('show')
                    });
                }

                const singleplayer = new Plyr('.video-player', {
                    controls,
                    ratio: '16:9',
                });

                let adPlayer = ''

                function adVideoPlayer() {
                    adPlayer = new Plyr('.ad-player', {
                        controls: [

                        ],
                        ratio: '16:9',
                    });
                }

                $(document).ready(function() {
                    let adTriggers = @json($adsDurations).map(Number);
                    let currentAdIndex = 0;
                    let adPlaying = false;

                    let requestPending = false;
                    let adVideo = $('.adVideo');
                    let slug = "{{ $video->slug }}"

                    function playAd(response) {
                        const adId = response.data.ad_id;
                        const encryptedVideoId = "{{ encrypt(@$video->id) }}";
                        adPlaying = true;
                        singleplayer.pause();
                        $('.mainVideo').addClass('d-none');

                        adVideo.html(`
                                <video class="ad-player" controls>
                                    <source src="${response.data.ad_video_src}" type="video/mp4" />
                                </video>
                                    ${(response.data.ad_type == 2 || response.data.ad_type == 3) ? `<div class="ad-info">
                                                            <div class="ad-info__thumb"><img src="${response.data.ad_logo}">
                                                            </div><div class="ad-info__content"><p>${response.data.ad_url}</p>
                                                                <a href="{{ route('redirect.ad', ['', '']) }}/${adId}/${encryptedVideoId}" class="text-white" target="_blank" >${response.data.button_label}</a>
                                                                </div></div>` : ''} 
                                <button class="skip-btn btn btn--base btn--sm ad-btn" type="button"></button>`);
                        adVideo.removeClass('d-none');
                        adVideoPlayer();
                        adPlayer.play();
                        adPlayer.on('timeupdate', function() {
                            const adDuration = 5;
                            const currentAdTime = Math.floor(adPlayer.currentTime);
                            let remainingTime = adDuration - currentAdTime;
                            if (remainingTime > 0) {
                                $('.skip-btn').attr('disabled', true).removeClass('d-none');
                                $('.skip-btn').text(`Skip in ${remainingTime} seconds`).removeClass('btn--base');
                            } else {
                                $('.skip-btn').attr('disabled', false).addClass('skipAd').addClass('btn--base');
                                $('.skip-btn').text('Skip');
                            }
                        });

                        adPlayer.once('ended', function() {
                            adPlayer.pause();
                            adVideo.addClass('d-none');
                            adVideo.empty();
                            $('.mainVideo').removeClass('d-none');
                            singleplayer.play();
                            adPlaying = false;
                        });
                    }

                    function requestAd() {
                        requestPending = true;
                        $.ajax({
                            type: "get",
                            url: "{{ route('fetch.ad') }}",
                            data: {
                                video_id: "{{ encrypt($video->id) }}"
                            },
                            dataType: "json",
                            success: function(response) {
                                if (response.status == 'success') {
                                    playAd(response);
                                }
                            },
                            complete: function() {
                                requestPending = false;
                            }
                        });
                    }

                    function checkAdTrigger() {
                        const currentTime = Math.floor(singleplayer.currentTime);
                        if (!adPlaying && !requestPending && adTriggers.includes(currentTime)) {
                            requestAd();
                            adTriggers.splice(adTriggers.indexOf(currentTime), 1);
                        }
                    }

                    let debounceTimer;
                    singleplayer.on('timeupdate', function() {
                        clearTimeout(debounceTimer);
                        debounceTimer = setTimeout(checkAdTrigger, 100);
                    });

                    $(document).on('click', '.skipAd', function() {
                        adPlayer.pause();
                        $('.adVideo').addClass('d-none');
                        $('.primary_ad_player').empty();
                        $('.mainVideo').removeClass('d-none');
                        singleplayer.play();
                        adPlaying = false;
                    })
                });

                const players = Plyr.setup('.related-video-player', {
                    controls: [],
                    ratio: '16:9',
                    muted: true,
                });

                $('.autoPlay').each(function() {
                    const player = $(this).find('.related-video-player')[0];

                    $(this).on('mouseenter', function() {
                        player.muted = true;
                        player.play().catch(function(error) {
                            console.warn('Autoplay failed:', error);
                        });
                    });

                    $(this).on('mouseleave', function() {
                        player.pause();
                        player.currentTime = 0;
                    });
                });

                const audience = "{{ $video->audience }}"
                if (audience == 0) {
                    if (stockVideo == 0 || purchasedTrue || authVideo) {
                        singleplayer.play();
                    }

                }

                $('.SeeBtn').on('click', function() {
                    $('.hidden-content').addClass('d-none');
                    singleplayer.play();
                });

                $('.reactionBtn').on('click', function() {
                    if (!auth) {
                        $('#existModalCenter').modal('show');
                        return;
                    }
                    const value = $(this).data('reaction');
                    const button = $(this);

                    $.ajax({
                        type: "post",
                        url: "{{ route('user.reaction', $video->id) }}",
                        dataType: "json",
                        data: {
                            is_like: value,
                        },
                        headers: {
                            'X-CSRF-TOKEN': "{{ csrf_token() }}"
                        },
                        success: function(response) {
                            const likeButton = $('.reactionBtn[data-reaction="1"]');
                            const dislikeButton = $('.reactionBtn[data-reaction="0"]');
                            const likeIcon = likeButton.find('.reactionIcon');
                            const dislikeIcon = dislikeButton.find('.reactionIcon');


                            if (response.remark == 'like') {
                                likeIcon.removeClass('vti-like').addClass('vti-like-fill');
                                $('.likeCount').text(response.data.like_count);

                                dislikeIcon.removeClass('vti-dislike-fill').addClass(
                                    'vti-dislike');

                            } else if (response.remark == 'like_remove') {
                                likeIcon.removeClass('vti-like-fill').addClass('vti-like');
                                $('.likeCount').text(response.data.like_count);

                            } else if (response.remark == 'dislike') {
                                dislikeIcon.removeClass('vti-dislike').addClass(
                                    'vti-dislike-fill');
                                likeIcon.removeClass('vti-like-fill').addClass('vti-like');
                                $('.likeCount').text(response.data.like_count);

                            } else if (response.remark == 'dislike_remove') {
                                dislikeIcon.removeClass('vti-dislike-fill').addClass(
                                    'vti-dislike');

                            } else if (response.status == 'status') {
                                notify('error', response.message.error);
                            } else {
                                notify('error', 'Failed to update reaction');
                                return;
                            }

                        }
                    });
                });
                // end reacrtion
            });



            // for subscribe

            $(document).on('click', '.unSubcriberBtn', function() {
                $('#unSubcriberModal').modal('show');
            });


            $(document).on('click', '.confirmUnsubscribe', function() {
                subscribers();
                $('#unSubcriberModal').modal('hide');
            });


            $(document).on('click', '.subcriberBtn', function() {
                subscribers();
            });


            function subscribers() {

                if (!auth) {
                    $('#existModalCenter').modal('show');
                    return;
                }

                $.ajax({
                    type: "post",
                    url: "{{ route('user.subscribe.channel', $video->user_id) }}",
                    dataType: "json",
                    headers: {
                        'X-CSRF-TOKEN': "{{ csrf_token() }}"
                    },
                    success: function(response) {

                        console.log(response);

                        $('.subscriberCount').text(response.data.subscriber_count);

                        if (response.remark === 'subscribed') {
                            $('.subscriber-btn').html(`
                  <button class="btn btn--white outline unSubcriberBtn"> @lang('Unsubscribe')</button> `)

                        } else if (response.remark === 'unsubscribe') {
                            $('.subscriber-btn').html(`
                 <button class="btn cta btn--white  subcriberBtn">@lang('Subscribe')
                                        <span class="shape">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </span></button>
                                    `)
                        } else {
                            notify('error', response.message);
                        }
                    }

                });
            }

            // end subscribe

            // for watch later

            $('.watchLater').on('click', function() {
                if (!auth) {
                    $('#existModalCenter').modal('show');
                    return;
                }
                var button = $(this);

                $.ajax({
                    type: "post",
                    url: "{{ route('user.watch.later', $video->id) }}",
                    dataType: "json",
                    headers: {
                        'X-CSRF-TOKEN': "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        if (response.remark == 'add_watch_later') {
                            button.find('.icon').html(`
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-square-check-big">
                        <path d="M21 10.5V19a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h12.5" />
                        <path d="m9 11 3 3L22 4" />
                    </svg>
                `);
                        } else if (response.remark == 'watch_later_remove') {
                            button.find('.icon').html(`
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-clock"><circle cx="12" cy="12" r="10"/><polyline points="12 6 12 12 16 14"/></svg>
                `);
                        }
                    }
                });
            });


            // end watch later

            // for share


            $('.shareBtn').on('click', function() {
                $('#shareModal').modal('show');
            });



            $(document).on('click', '.copyBtn', function(e) {

                var input = $(this).parent('.share-embed').find('.copyText');
                if (input && input.select) {
                    input.select();
                    try {
                        document.execCommand('SelectAll')
                        document.execCommand('Copy', false, null);
                        input.blur();
                        notify('success', `Copied successfully`);
                    } catch (err) {
                        alert('Please press Ctrl/Cmd + C to copy');
                    }
                }
            });

            // end share


            // for comment 
            let currentPage = 1;

            let lastPage = false;




            $('.comment-form').on('submit', function(e) {
                e.preventDefault();

                if (!auth) {
                    $('#existModalCenter').modal('show');
                    return;
                }

                $.ajax({
                    type: "post",
                    url: "{{ route('user.comment.submit', $video->id) }}",
                    data: $(this).serialize(),
                    dataType: "json",
                    headers: {
                        'X-CSRF-TOKEN': "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        if (response.status === 'success') {
                            $('.commentBox').css('height', '');
                            $('.comment-box__content').prepend(response.data.comment);
                            $('.comment-form').trigger('reset');
                            $('.commentCount').text(response.data.comment_count);

                        } else {
                            notify('error', response.message.error);
                        }
                    }
                });
            });

            $('.comment-box__content').on('scroll', function() {
                let commentBox = $(this);
                let scrollTop = commentBox.scrollTop();
                let boxHeight = commentBox.outerHeight();
                let contentHeight = commentBox[0].scrollHeight;

                if (scrollTop + boxHeight >= contentHeight - 2 && !lastPage) {
                    currentPage++;
                    loadMoreComments();
                }
            });

            function loadMoreComments() {
                const commentsRoute = "{{ route('user.comment.get', $video->id) }}";
                $('#loading-spinner').removeClass('d-none');
                $.ajax({
                    url: `${commentsRoute}?page=${currentPage}`,
                    type: 'GET',
                    success: function(response) {
                        $('#loading-spinner').addClass('d-none');
                        if (response.status == 'success') {
                            $('.comment-box__content').append(response.data.commentHtml);
                            $('.commentCount').text(response.data.comment_count);
                            if (currentPage >= response.data.last_page) {
                                lastPage = true;
                            }
                        } else {
                            notify('error', response.message.error);
                        }
                    }
                });
            }



            $(document).on('click', '.reply', function() {
                const replyForm = $(this).closest('.comment-box-item__content').find('.reply-form').first();
                replyForm.toggleClass('d-none');
            });




            $(document).on('submit', '.reply-form', function(e) {
                e.preventDefault();

                if (!auth) {
                    $('#existModalCenter').modal('show');
                    return;
                }

                const form = $(this);

                $.ajax({
                    type: "post",
                    url: "{{ route('user.comment.reply') }}",
                    data: form.serialize(),
                    headers: {
                        'X-CSRF-TOKEN': "{{ csrf_token() }}"
                    },
                    dataType: "json",
                    success: function(response) {
                        if (response.status === 'success') {
                            form.trigger('reset');
                            $('.commentBox').css('height', '');

                            var repliesContainer = form.closest('.parentComment').find(
                                '.reply-wrapper').first();

                            if (repliesContainer.length) {
                                repliesContainer.append(response.data.reply);
                            }

                            $('.commentCount').text(response.data.comment_count);
                        } else {
                            notify('error', response.message.error);
                        }
                    }
                });
            });


            $(document).on('click', '.show-reply', function() {
                var replies = $(this).next('.append-reply');
                if (replies.hasClass('d-none')) {
                    replies.removeClass('d-none').hide().slideDown();
                    $(this).find('.text').text('Hide Replies');
                    $(this).addClass('active');

                } else {
                    replies.slideUp(function() {
                        replies.addClass('d-none').show();
                    });
                    $(this).find('.text').text('Show Replies');
                    $(this).removeClass('active');

                }
            });




            // for reaction
            $(document).on('click', '.commentReaction', function() {
                if (!auth) {
                    $('#existModalCenter').modal('show');
                    return;
                }

                const value = $(this).data('reaction');
                const commentId = $(this).data('comment_id');
                const button = $(this);

                $.ajax({
                    type: "post",
                    url: "{{ route('user.comment.like.dislike') }}/" + commentId,
                    dataType: "json",
                    data: {
                        is_like: value,
                        comment_id: commentId,
                    },
                    headers: {
                        'X-CSRF-TOKEN': "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        if (response.remark === 'like') {
                            button.find('.reactionIcon').removeClass('vti-like').addClass(
                                'vti-like-fill');
                            button.siblings('.commentReaction').find('.reactionIcon').removeClass(
                                'vti-dislike-fill').addClass('vti-dislike');
                            button.find('.likeCount').text(response.data.like_count);

                        } else if (response.remark === 'like_remove') {
                            button.find('.reactionIcon').removeClass('vti-like-fill').addClass(
                                'vti-like');
                            button.find('.likeCount').text(response.data.like_count);

                        } else if (response.remark === 'dislike') {
                            button.find('.reactionIcon').removeClass('vti-dislike').addClass(
                                'vti-dislike-fill');
                            button.siblings('.commentReaction').find('.reactionIcon').removeClass(
                                'vti-like-fill').addClass('vti-like');
                            button.siblings('.commentReaction').find('.likeCount').text(response
                                .data.like_count);

                        } else if (response.remark === 'dislike_remove') {
                            button.find('.reactionIcon').removeClass('vti-dislike-fill').addClass(
                                'vti-dislike');

                        } else if (response.remark === 'video_not_found') {
                            notify('error', response.message.error);
                        } else {
                            notify('error', 'Failed to update reaction');
                        }

                    }
                });
            });
            // end comment

            //embed

            $('.embed').on('click', function() {
                $('#embedModal').modal('show');
            });
            $('.saveBtn').on('click', function() {
                const modal = $('#addVideoModal');
                modal.find('.modal-title').text('Playlists');
                modal.modal('show')
            })
        })(jQuery);
    </script>
@endpush

@if (!$purchasedTrue)
    @push('script')
        <script>
            "use strict";
            (function($) {

                var amount = parseFloat($('.amount').val() || 0);


                var gateway, minAmount, maxAmount;

                $('.amount').on('input', function(e) {
                    amount = parseFloat($(this).val());
                    if (!amount) {
                        amount = 0;
                    }
                    calculation();
                });

                $('.gateway-input').on('change', function(e) {
                    gatewayChange();
                });

                function gatewayChange() {
                    let gatewayElement = $('.gateway-input:checked');
                    let methodCode = gatewayElement.val();

                    gateway = gatewayElement.data('gateway');
                    minAmount = gatewayElement.data('min-amount');
                    maxAmount = gatewayElement.data('max-amount');

                    let processingFeeInfo =
                        `${parseFloat(gateway.percent_charge).toFixed(2)}% with ${parseFloat(gateway.fixed_charge).toFixed(2)} {{ __(gs('cur_text')) }} charge for payment gateway processing fees`
                    $(".proccessing-fee-info").attr("data-bs-original-title", processingFeeInfo);
                    calculation();
                }

                gatewayChange();

                $(".more-gateway-option").on("click", function(e) {
                    let paymentList = $(".gateway-option-list");
                    paymentList.find(".gateway-option").removeClass("d-none");
                    $(this).addClass('d-none');
                    paymentList.animate({
                        scrollTop: (paymentList.height() - 60)
                    }, 'slow');
                });

                function calculation() {
                    if (!gateway) return;
                    $(".gateway-limit").text(minAmount + " - " + maxAmount);

                    let percentCharge = 0;
                    let fixedCharge = 0;
                    let totalPercentCharge = 0;

                    if (amount) {
                        percentCharge = parseFloat(gateway.percent_charge);
                        fixedCharge = parseFloat(gateway.fixed_charge);
                        totalPercentCharge = parseFloat(amount / 100 * percentCharge);
                    }

                    let totalCharge = parseFloat(totalPercentCharge + fixedCharge);
                    let totalAmount = parseFloat((amount || 0) + totalPercentCharge + fixedCharge);

                    $(".final-amount").text(totalAmount.toFixed(2));
                    $(".processing-fee").text(totalCharge.toFixed(2));
                    $("input[name=currency]").val(gateway.currency);
                    $(".gateway-currency").text(gateway.currency);

                    if (amount < Number(gateway.min_amount) || amount > Number(gateway.max_amount)) {
                        $(".deposit-form button[type=submit]").attr('disabled', true);
                    } else {
                        $(".deposit-form button[type=submit]").removeAttr('disabled');
                    }

                    if (gateway.currency != "{{ gs('cur_text') }}" && gateway.method.crypto != 1) {
                        $('.deposit-form').addClass('adjust-height')

                        $(".gateway-conversion, .conversion-currency").removeClass('d-none');
                        $(".gateway-conversion").find('.deposit-info__input .text').html(
                            `1 {{ __(gs('cur_text')) }} = <span class="rate">${parseFloat(gateway.rate).toFixed(2)}</span>  <span class="method_currency">${gateway.currency}</span>`
                        );
                        $('.in-currency').text(parseFloat(totalAmount * gateway.rate).toFixed(gateway.method.crypto == 1 ?
                            8 : 2))
                    } else {
                        $(".gateway-conversion, .conversion-currency").addClass('d-none');
                        $('.deposit-form').removeClass('adjust-height')
                    }

                    if (gateway.method.crypto == 1) {
                        $('.crypto-message').removeClass('d-none');
                    } else {
                        $('.crypto-message').addClass('d-none');
                    }
                }

                var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
                var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                    return new bootstrap.Tooltip(tooltipTriggerEl)
                })
                $('.gateway-input').change();
            })(jQuery);
        </script>
    @endpush
@endif
