<div class="upload">
    <div class="upload__outer">
        <div class="upload__dragBox">
            <div class="upload-box">
                <span class="spiner-upload">
                </span>
                <span class="icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 24 24"
                         fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                         stroke-linejoin="round" class="lucide lucide-file-video-2">
                        <path d="M4 22h14a2 2 0 0 0 2-2V7l-5-5H6a2 2 0 0 0-2 2v4" />
                        <path d="M14 2v4a2 2 0 0 0 2 2h4" />
                        <rect width="8" height="6" x="2" y="12" rx="1" />
                        <path d="m10 15.5 4 2.5v-6l-4 2.5" />
                    </svg>
                </span>
            </div>

            <h4 class="title">@lang('Drag and drop video files to upload')</h4>
            <span class="tagDes">@lang('Your video will be private until you publish them')</span>
            <input class="uploadFile" id="upload__uploadFile" type="file" ondragover="drag()" ondrop="drop()" accept="video/*" />
        </div>

        @if (!request()->routeIs('user.shorts.*') && gs('ffmpeg_status'))
            <p class="text mt-3">@lang('Supported Resulation: ') (
                @foreach ($resolutions as $resolution)
                    <span>{{ $resolution->width }} X {{ $resolution->height }}</span>
                    @if (!$loop->last)
                        ,
                    @endif
                @endforeach
                )
            </p>
        @endif
        <p class="text mt-3" >
        @lang(' Allowed File Extensions: .mp4, .mov, .wmv, .flv, .avi, .mkv')
        </p>
        <label class="btn btn--base" for="upload__uploadFile">@lang('Select Files')</label>
    </div>

</div>

@push('style')
    <style>
        .animation-box .icon {
            display: none;
        }

        .spiner-upload {
            display: none;
        }

        .spiner-upload {
            height: 40px;
            width: 40px;
            border-radius: 50%;
            border: 2px solid hsl(var(--info));
            border-top-color: transparent;
        }

        .animation-box .spiner-upload {
            display: block;
            animation: move-top 1s linear infinite;
        }

        @keyframes move-top {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .upload-box {
            height: 160px;
            width: 160px;
            border-radius: 50%;
            position: relative;
            margin: 0 auto 16px;
            display: flex;
            justify-content: center;
            align-items: center;
            overflow: hidden;
            background: hsl(var(--white) / .1);
            border: 1px dashed hsl(var(--white) / .3);
        }

        .animation-box.upload-box {
            border-color: hsl(var(--info));
            background: hsl(var(--info) / .1);
        }
    </style>
@endpush
@push('script')
    <script>
        (function($) {
            "use strict";

            function drag() {
                document.getElementById('upload__uploadFile').parentNode.className = 'draging upload__dragBox';
            }

            function drop() {
                document.getElementById('upload__uploadFile').parentNode.className = 'upload__dragBox';
            }

            const shorts = "{{ $isShorts }}"


            $(document).ready(function() {
                $('.uploadFile').on('change', function(event) {
                    var url = null;

                    if (shorts) {
                        url = "{{ route('user.shorts.upload', @$video->id) }}";
                    } else {

                        url = "{{ route('user.video.upload', @$video->id) }}";
                    }


                    const file = $(this)[0].files[0];

                    if (!file) return;

                    $('.upload-box').addClass('animation-box');
                    $('.icon').addClass('animated-upload');

                    const formData = new FormData();
                    formData.append('video', file);

                    $.ajax({
                        type: "POST",
                        url: url,
                        data: formData,
                        headers: {
                            'X-CSRF-TOKEN': "{{ csrf_token() }}"
                        },
                        processData: false,
                        contentType: false,
                        dataType: "json",
                        success: function(response) {
                            if (response.status == 'success') {
                                $('.upload-box').removeClass('animation-box');
                                $('.icon').removeClass('animated-upload');
                                notify('success', response.message.success);
                                if (response.data.video_type == 'Short') {
                                    window.location.href = "{{ route('user.shorts.details.form') }}/" + response.data.video.id;

                                } else {
                                    window.location.href = "{{ route('user.video.details.form') }}/" + response.data.video.id;
                                }
                            } else {
                                $('.upload-box').removeClass('animation-box');
                                $('.icon').removeClass('animated-upload');
                                notify('error', response.message.error);
                            }
                        }
                    });
                });
            });

        })(jQuery)
    </script>
@endpush
