<div class="modal custom--modal scale-style fade" id="playlistModal" tabindex="-1" aria-labelledby="playlistModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Add Playlist')</h5>
                <button type="button" class="close modal-close-btn" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form method="post" class="playlistForm">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <div class="d-flex justify-content-between">
                            <label class="form--label">@lang('Title')</label> <a class="playListbuildSlug fs-14"
                               href="javescript:void(0)"><i class="las la-link"></i>@lang('Make Slug')</a>
                        </div>
                        <input class="form--control" type="text" name="title" value="{{ old('title') }}" required>
                    </div>
                    <div class="form-group">
                        <div class="d-flex justify-content-between">
                            <label class="form--label">@lang('slug')</label>
                            <div class="slug-verification d-none"></div>
                        </div>
                        <input class="form--control playListSlug" type="text" name="slug" value="{{ old('slug') }}" required>
                    </div>
                    <div class="form-group">
                        <label for="" class="form--label">@lang('Description (Optional)')</label>
                        <textarea name="description" class="form--control" cols="30" rows="10">{{ old('description') }}</textarea>
                    </div>
                    <div class="form-group select2-parent">
                        <label for="" class="form--label">@lang('Visibility')</label>
                        <div class="check-type-wrapper">
                            <label for="category01" class="check-type check-type-success">
                                <input class="check-type-input" type="radio" value="0" name="visibility"
                                       id="category01" checked="">
                                <span class="check-type-icon">
                                    <svg class="check-circle" width="13" height="10" viewBox="0 0 13 10"
                                         fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1 5L4.5 8.5L12.5 0.5" stroke="currentColor" stroke-linecap="round"
                                              class="check">
                                        </path>
                                    </svg>
                                </span>
                                <span class="check-type-label">@lang('Public')</span>
                            </label>

                            <label for="category02" class="check-type check-type-warning">
                                <input class="check-type-input" type="radio" value="1" name="visibility"
                                       id="category02">
                                <span class="check-type-icon">
                                    <svg class="check-circle" width="13" height="10" viewBox="0 0 13 10"
                                         fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1 5L4.5 8.5L12.5 0.5" stroke="currentColor" stroke-linecap="round"
                                              class="check">
                                        </path>
                                    </svg>
                                </span>
                                <span class="check-type-label">@lang('Private')</span>
                            </label>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--white submitBtn">@lang('Create')</button>
                </div>
            </form>
        </div>
    </div>
</div>


@push('script')
    <script>
        $('.playListbuildSlug').on('click', function() {
            let closestForm = $(this).closest('form');
            let title = closestForm.find(`[name="title"]`).val();
            closestForm.find('.playListSlug').val(title);
            closestForm.find('.playListSlug').trigger('input');
        });



        $('.playListSlug').on('input', function() {
            let closestForm = $(this).closest('form');
            let slug = $(this).val();
            slug = slug.toLowerCase().replace(/ /g, '-').replace(/[^\w-]+/g, '');
            $(this).val(slug);
            if (slug) {
                closestForm.find('.slug-verification').removeClass('d-none');
                closestForm.find('.slug-verification').html(`
                    <small class="text--info"><i class="las la-spinner la-spin"></i> @lang('Verifying')</small>
                `);
                $.get("{{ route('user.playlist.check.slug') }}", {
                    slug: slug,

                }, function(response) {
                    console.log(response);

                    if (!response.exists) {
                        closestForm.find('.slug-verification').html(`
                            <small class="text--success"><i class="las la-check"></i> @lang('Verified')</small>
                        `);
                    }

                    if (response.exists) {
                        closestForm.find('.slug-verification').html(`
                            <small class="text--danger"><i class="las la-times"></i> @lang('Slug already exists')</small>
                        `);
                    }
                });
            } else {
                closestForm.find('.slug-verification').addClass('d-none');
            }
        });
    </script>
@endpush
