<div class="home-body channel-body @if (!blank($videos)) home-body__shorts @else empty-body__shorts @endif">
    @if (!blank($videos))
        @include($activeTemplate . 'partials.video.shorts_list', ['shortVideos' => $videos])
    @else
        <div class="empty-container">
            @include('Template::partials.empty')
        </div>
    @endif
</div>
<div class="text-center d-none spinner mt-4" id="loading-spinner">
    <i class="las la-spinner"></i>
</div>
<!-- Spinner for loading more comments -->



@push('style')
    <style>
        .spinner {
            text-align: center;
            margin-top: 20px;
        }




        .spinner i {
            font-size: 45px;
            color: #ff0000;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .empty-body__shorts {
            display: grid;
            grid-template-columns: unset;

        }
    </style>
@endpush

@push('style-lib')
    <link href="{{ asset('assets/global/css/plyr.css') }}" rel="stylesheet">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/global/js/plyr.js') }}"></script>
@endpush


@push('script')
    <script>
        (function($) {
            'use strict';


            const controls = [

            ];


            $(document).ready(function() {
                shortPlayers();
                initiateAutoPlay();

            });


            function shortPlayers() {
                Plyr.setup('.shorts-video-player', {
                    controls,
                    ratio: '9:16',
                    muted: true,
                });

            }

            // for comment 
            let currentPage = "{{ $videos->currentPage() }}";
            let lastPage = false;


            $(window).scroll(function() {
                if ($(window).scrollTop() + $(window).height() >= $(document).height() - 0 && !lastPage) {
                    currentPage++;
                    loadMoreVideos();

                }
            });


            function loadMoreVideos() {
                const route = "{{ route('load.shorts.video', $user->id) }}";

                $('#loading-spinner').removeClass('d-none');

                $.ajax({
                    url: `${route}?page=${currentPage}`,
                    type: 'GET',
                    success: function(response) {
                        if (response.status === 'success') {


                            $('#loading-spinner').addClass('d-none');
                            appendVideos(response.data.videos);

                            if (currentPage >= response.data.last_page) {
                                lastPage = true;
                            }
                        } else {
                            notify('error', response.message.error);
                        }
                    }
                });
            }

            const thumbPath = "{{ asset(getFilePath('thumbnail')) }}"
            const userProfilePath = "{{ asset(getFilePath('userProfile')) }}"
            const videoPath = "{{ asset(getFilePath('video')) }}"

            function appendVideos(videos) {


                $.each(videos, function(index, video) {
                    const url = "{{ route('short.play') }}/" + video.id + '/' + video.slug;
                    const userId = "{{ auth()->id() }}"

                    let videoHtml = `
            


                <div class="short-item">
    <a href="{{ route('preview.channel', '') }}/${video.user.slug}" class="short-item__channel">
        <img src="` + userProfilePath + '/' + video.user.image + `"
            alt="Short Author">
    </a>
    <a href="${url}" class="short-item__thumb shortsAutoPlay">
        <video class="shorts-video-player" controls>
            <source src="` + videoPath + '/' + video.video + `" type="video/mp4" />

        </video>
    </a>
    <div class="short-item__content">
        <h5 class="short-item__title">
             <a href="${url}">${video.title}</a>
        </h5>

        <span class="short-item__view">${video.views} @lang('views')</span>
    </div>
</div>
            `

                    $('.home-body__shorts').append(videoHtml);

                });
                shortPlayers();


                initiateAutoPlay();

            }



            function initiateAutoPlay() {
                handleAutoPlay('.shortsAutoPlay', '.shorts-video-player');
            }


            function handleAutoPlay(selector, playerClass) {
                $(selector).each(function() {
                    const player = $(this).find(playerClass)[0];

                    $(this).on('mouseenter', function() {


                        if (player) {
                            player.play();
                            player.muted = true;
                        }
                    });

                    $(this).on('mouseleave', function() {
                        if (player) {
                            player.pause();
                            player.currentTime = 0;
                        }
                    });
                });
            }

        })(jQuery);
    </script>
@endpush
