@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <div class="home-body">
        <div class="home-body__item">
            <h3 class="home-body__title">
                <span class="icon"><i class="vti-top"></i></span>
                @lang('Trending')
            </h3>
        </div>
        <section class="trending-section">
            <div class="video-item-wrapper">
                @include($activeTemplate . 'partials.video.video_list', ['videos' => $trendingVideos])
            </div>
        </section>

        <div class="home-body__item">
            <h3 class="home-body__title">
                <span class="icon"><i class="vti-short"></i></span>@lang('Shorts')
            </h3>
        </div>

        <section class="shorts-section">
            <div class="row gy-4">
                <div class="col-lg-12">
                    <div class="short_slider owl-carousel">
                        @include($activeTemplate . 'partials.video.shorts_list', ['shortVideos' => $shortVideos])
                    </div>
                </div>
            </div>
        </section>

        <div class="home-body__item">
            <h3 class="home-body__title"><span class="icon"><i class="vti-video"></i></span>@lang('Videos')</h3>
        </div>

        <div class="video-wrapper">
            @include($activeTemplate . 'partials.video.video_list', ['videos' => $videos])
        </div>
        <div class="text-center d-none spinner mt-4 w-100" id="loading-spinner">
            <i class="las la-spinner"></i>
        </div>


    </div>
@endsection

@push('style')
    <style>
        .spinner {
            text-align: center;
            margin-top: 20px;
        }

        .spinner i {
            font-size: 45px;
            color: #ff0000;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }
    </style>
@endpush


@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/global/css/plyr.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/global/js/plyr.js') }}"></script>
@endpush

@push('script')
    <script>
        (function($) {
            'use strict';

            $(document).ready(function() {

                playersInitiate()
            });


            const controls = [
                'duration',

            ];

            function playersInitiate() {

                const players = Plyr.setup('.video-player', {
                    controls,
                    ratio: '16:9',
                    muted: true,
                });

            }

            $(document).ready(function() {


                const shortPlayers = Plyr.setup('.shorts-video-player', {
                    controls,
                    ratio: '9:16',
                    muted: true,
                });


            });

            // for videos 
            let currentPage = "{{ $videos->currentPage() }}";
            let lastPage = false;


            $(window).scroll(function() {
                if ($(window).scrollTop() + $(window).height() >= $(document).height() - 0 && !lastPage) {
                    currentPage++;
                    loadMoreVideos();
                }
            });


            function loadMoreVideos() {
                const route = "{{ route('video.get') }}";
                $('#loading-spinner').removeClass('d-none');

                $.ajax({
                    url: `${route}?page=${currentPage}`,
                    type: 'GET',
                    success: function(response) {
                        if (response.status === 'success') {

                            $('#loading-spinner').addClass('d-none');
                            appendVideos(response.data.videos);
                            if (currentPage >= response.data.last_page) {
                                lastPage = true;
                            }
                        } else {
                            notify('error', response.message.error);
                        }
                    }
                });
            }


            function appendVideos(videos) {
                $('.video-wrapper').append(videos);
                playersInitiate();
                initiateAutoPlay();
            }


            $(document).ready(function() {
                initiateAutoPlay();
            });

            function initiateAutoPlay() {
                handleAutoPlay('.autoPlay', '.video-player');
                handleAutoPlay('.shortsAutoPlay', '.shorts-video-player');
            }


            function handleAutoPlay(selector, playerClass) {
                $(selector).each(function() {
                    const player = $(this).find(playerClass)[0];

                    $(this).on('mouseenter', function() {


                        if (player) {
                            player.play();
                            player.muted = true;
                        }
                    });

                    $(this).on('mouseleave', function() {
                        if (player) {
                            player.pause();
                            player.currentTime = 0;
                        }
                    });
                });
            }

        })(jQuery);
    </script>
@endpush
